function [residual, g1, g2, g3] = World_Economy_Competitive_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 33, 1);

%
% Model equations
%

T14 = (params(2)-1)/params(2);
T17 = exp(T14*y(25));
T22 = exp(y(19))^params(3);
T26 = exp(y(20))^(1-params(3));
T27 = T22*T26;
T28 = T27^T14;
T34 = (1-params(11))*T17*T28+params(11)*exp(y(15))^T14;
T41 = exp(y(18))^(1/params(2));
T43 = (-1)/params(2);
T44 = exp(y(15))^T43;
T52 = T27^T43;
T56 = exp(y(20))^(-params(3));
T66 = exp(y(19))^(params(3)-1);
T116 = params(9)^((-1)/params(8));
T122 = exp(y(24));
T132 = exp(y(21))-params(9)*exp(y(20))^(1+params(8))/(1+params(8));
T135 = T132^(-params(14));
T163 = params(13)^(1-params(4));
T186 = T122*(exp(y(1))*exp((-y(26)))*exp(y(10))+y(16)*(1-exp((-y(26)))*exp(y(10)))-params(6)*exp(params(5)*(y(10)-y(26))));
T197 = params(12)^(1-params(4));
lhs =exp(y(18));
rhs =T34^(params(2)/(params(2)-1));
residual(1)= lhs-rhs;
lhs =exp(y(1));
rhs =params(11)*T41*T44;
residual(2)= lhs-rhs;
lhs =exp(y(23));
rhs =T22*T41*T17*(1-params(11))*(1-params(3))*T52*T56;
residual(3)= lhs-rhs;
lhs =exp(y(22));
rhs =T26*T52*T41*T17*(1-params(11))*params(3)*T66;
residual(4)= lhs-rhs;
lhs =exp(y(12));
rhs =T17*exp(y(19)*params(3))*exp(y(20)*(1-params(3)));
residual(5)= lhs-rhs;
lhs =exp(y(19))+exp(y(21))+exp(y(3))+exp(y(2))+params(6)*exp(params(5)*y(11))*exp(y(7))+params(6)*exp(params(5)*(y(10)-y(26)))*exp(y(6));
rhs =exp(y(18))+exp(y(19))*(1-params(10));
residual(6)= lhs-rhs;
lhs =exp(y(20));
rhs =T116*exp(y(23))^(1/params(8));
residual(7)= lhs-rhs;
lhs =1;
rhs =T122*(1+exp(y(22))-params(10));
residual(8)= lhs-rhs;
lhs =T122;
rhs =params(1)*T135/T135;
residual(9)= lhs-rhs;
lhs =y(13);
rhs =T122*(exp(y(1))*exp(y(11))+y(13)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)));
residual(10)= lhs-rhs;
lhs =y(14);
rhs =y(13)*params(7)+y(14)*T122*(1-params(7));
residual(11)= lhs-rhs;
lhs =y(14)*params(4)*exp(y(3)*(params(4)-1))*T163;
rhs =1;
residual(12)= lhs-rhs;
lhs =T122*params(6)*params(5)*exp(y(11)*(params(5)-1));
rhs =T122*(exp(y(1))-y(13));
residual(13)= lhs-rhs;
lhs =y(16);
rhs =T186;
residual(14)= lhs-rhs;
lhs =y(17);
rhs =params(7)*y(16)+T122*(1-params(7))*y(17);
residual(15)= lhs-rhs;
lhs =y(17)*params(4)*exp(y(2)*(params(4)-1))*T197;
rhs =1;
residual(16)= lhs-rhs;
lhs =T122*params(6)*params(5)*exp(y(10)*(params(5)-1))*exp(y(26)*(-params(5)));
rhs =T122*exp((-y(26)))*(exp(y(1))-y(16));
residual(17)= lhs-rhs;
lhs =exp(y(7));
rhs =exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(9));
residual(18)= lhs-rhs;
lhs =exp(y(6));
rhs =exp(y(6))*(1-exp((-y(26)))*exp(y(10)))+params(7)*exp(y(8));
residual(19)= lhs-rhs;
lhs =exp(y(9));
rhs =(1-params(7))*exp(y(9))+T163*exp(y(3)*params(4));
residual(20)= lhs-rhs;
lhs =exp(y(8));
rhs =(1-params(7))*exp(y(8))+T197*exp(y(2)*params(4));
residual(21)= lhs-rhs;
lhs =exp(y(5));
rhs =exp(y(7))*exp(y(11));
residual(22)= lhs-rhs;
lhs =exp(y(4));
rhs =exp(y(6))*exp((-y(26)))*exp(y(10));
residual(23)= lhs-rhs;
lhs =exp(y(15));
rhs =exp(y(5))+exp(y(4));
residual(24)= lhs-rhs;
lhs =y(26);
rhs =x(1);
residual(25)= lhs-rhs;
lhs =y(25);
rhs =x(2)+y(25)*params(15)+y(25)*params(16);
residual(26)= lhs-rhs;
residual(27) = y(27);
residual(28) = y(28);
residual(29) = y(29);
residual(30) = y(30);
residual(31) = y(31);
residual(32) = y(32);
lhs =y(33);
rhs =y(25);
residual(33)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(33, 33);

  %
  % Jacobian matrix
  %

T348 = getPowerDeriv(T34,params(2)/(params(2)-1),1);
T359 = exp(y(18))*getPowerDeriv(exp(y(18)),1/params(2),1);
T375 = exp(y(19))*getPowerDeriv(exp(y(19)),params(3),1);
T377 = getPowerDeriv(T27,T14,1);
T382 = getPowerDeriv(T27,T43,1);
T404 = exp(y(20))*getPowerDeriv(exp(y(20)),1-params(3),1);
T405 = T22*T404;
T433 = getPowerDeriv(T132,(-params(14)),1);
T434 = (-(params(9)*exp(y(20))*getPowerDeriv(exp(y(20)),1+params(8),1)/(1+params(8))))*T433;
  g1(1,15)=(-(params(11)*exp(y(15))*getPowerDeriv(exp(y(15)),T14,1)*T348));
  g1(1,18)=exp(y(18));
  g1(1,19)=(-(T348*(1-params(11))*T17*T26*T375*T377));
  g1(1,20)=(-(T348*(1-params(11))*T17*T377*T405));
  g1(1,25)=(-(T348*T28*(1-params(11))*T14*T17));
  g1(2,1)=exp(y(1));
  g1(2,15)=(-(params(11)*T41*exp(y(15))*getPowerDeriv(exp(y(15)),T43,1)));
  g1(2,18)=(-(T44*params(11)*T359));
  g1(3,18)=(-(T56*T22*T52*T17*(1-params(11))*(1-params(3))*T359));
  g1(3,19)=(-(T56*(T41*T17*(1-params(11))*(1-params(3))*T52*T375+T22*T41*T17*(1-params(11))*(1-params(3))*T26*T375*T382)));
  g1(3,20)=(-(T56*T22*T41*T17*(1-params(11))*(1-params(3))*T382*T405+T22*T41*T17*(1-params(11))*(1-params(3))*T52*exp(y(20))*getPowerDeriv(exp(y(20)),(-params(3)),1)));
  g1(3,23)=exp(y(23));
  g1(3,25)=(-(T56*T22*T52*T41*(1-params(11))*(1-params(3))*T14*T17));
  g1(4,18)=(-(T26*T66*T52*T17*(1-params(11))*params(3)*T359));
  g1(4,19)=(-(T26*(T66*T41*T17*(1-params(11))*params(3)*T26*T375*T382+T52*T41*T17*(1-params(11))*params(3)*exp(y(19))*getPowerDeriv(exp(y(19)),params(3)-1,1))));
  g1(4,20)=(-(T52*T41*T17*(1-params(11))*params(3)*T66*T404+T26*T66*T41*T17*(1-params(11))*params(3)*T382*T405));
  g1(4,22)=exp(y(22));
  g1(4,25)=(-(T26*T66*T52*T41*(1-params(11))*params(3)*T14*T17));
  g1(5,12)=exp(y(12));
  g1(5,19)=(-(exp(y(20)*(1-params(3)))*T17*params(3)*exp(y(19)*params(3))));
  g1(5,20)=(-(T17*exp(y(19)*params(3))*(1-params(3))*exp(y(20)*(1-params(3)))));
  g1(5,25)=(-(exp(y(20)*(1-params(3)))*exp(y(19)*params(3))*T14*T17));
  g1(6,2)=exp(y(2));
  g1(6,3)=exp(y(3));
  g1(6,6)=params(6)*exp(params(5)*(y(10)-y(26)))*exp(y(6));
  g1(6,7)=params(6)*exp(params(5)*y(11))*exp(y(7));
  g1(6,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(26)));
  g1(6,11)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
  g1(6,18)=(-exp(y(18)));
  g1(6,19)=exp(y(19))-exp(y(19))*(1-params(10));
  g1(6,21)=exp(y(21));
  g1(6,26)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(26)))*(-params(5));
  g1(7,20)=exp(y(20));
  g1(7,23)=(-(T116*exp(y(23))*getPowerDeriv(exp(y(23)),1/params(8),1)));
  g1(8,22)=(-(exp(y(22))*T122));
  g1(8,24)=(-(T122*(1+exp(y(22))-params(10))));
  g1(9,20)=(-((T135*params(1)*T434-params(1)*T135*T434)/(T135*T135)));
  g1(9,21)=(-((T135*params(1)*exp(y(21))*T433-params(1)*T135*exp(y(21))*T433)/(T135*T135)));
  g1(9,24)=T122;
  g1(10,1)=(-(T122*exp(y(1))*exp(y(11))));
  g1(10,11)=(-(T122*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*exp(params(5)*y(11)))));
  g1(10,13)=1-T122*(1-exp(y(11)));
  g1(10,24)=(-(T122*(exp(y(1))*exp(y(11))+y(13)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))));
  g1(11,13)=(-params(7));
  g1(11,14)=1-T122*(1-params(7));
  g1(11,24)=(-(y(14)*T122*(1-params(7))));
  g1(12,3)=y(14)*T163*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(12,14)=params(4)*exp(y(3)*(params(4)-1))*T163;
  g1(13,1)=(-(exp(y(1))*T122));
  g1(13,11)=T122*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(13,13)=T122;
  g1(13,24)=T122*params(6)*params(5)*exp(y(11)*(params(5)-1))-T122*(exp(y(1))-y(13));
  g1(14,1)=(-(T122*exp(y(1))*exp((-y(26)))*exp(y(10))));
  g1(14,10)=(-(T122*(exp(y(1))*exp((-y(26)))*exp(y(10))+y(16)*(-(exp((-y(26)))*exp(y(10))))-params(6)*params(5)*exp(params(5)*(y(10)-y(26))))));
  g1(14,16)=1-T122*(1-exp((-y(26)))*exp(y(10)));
  g1(14,24)=(-T186);
  g1(14,26)=(-(T122*(exp(y(1))*exp(y(10))*(-exp((-y(26))))+y(16)*(-(exp(y(10))*(-exp((-y(26))))))-params(6)*exp(params(5)*(y(10)-y(26)))*(-params(5)))));
  g1(15,16)=(-params(7));
  g1(15,17)=1-T122*(1-params(7));
  g1(15,24)=(-(T122*(1-params(7))*y(17)));
  g1(16,2)=y(17)*T197*params(4)*(params(4)-1)*exp(y(2)*(params(4)-1));
  g1(16,17)=params(4)*exp(y(2)*(params(4)-1))*T197;
  g1(17,1)=(-(exp(y(1))*T122*exp((-y(26)))));
  g1(17,10)=T122*exp(y(26)*(-params(5)))*params(6)*params(5)*(params(5)-1)*exp(y(10)*(params(5)-1));
  g1(17,16)=T122*exp((-y(26)));
  g1(17,24)=T122*params(6)*params(5)*exp(y(10)*(params(5)-1))*exp(y(26)*(-params(5)))-T122*exp((-y(26)))*(exp(y(1))-y(16));
  g1(17,26)=T122*params(6)*params(5)*exp(y(10)*(params(5)-1))*(-params(5))*exp(y(26)*(-params(5)))-(exp(y(1))-y(16))*T122*(-exp((-y(26))));
  g1(18,7)=exp(y(7))-exp(y(7))*(1-exp(y(11)));
  g1(18,9)=(-(params(7)*exp(y(9))));
  g1(18,11)=(-(exp(y(7))*(-exp(y(11)))));
  g1(19,6)=exp(y(6))-exp(y(6))*(1-exp((-y(26)))*exp(y(10)));
  g1(19,8)=(-(params(7)*exp(y(8))));
  g1(19,10)=(-(exp(y(6))*(-(exp((-y(26)))*exp(y(10))))));
  g1(19,26)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(26))))))));
  g1(20,3)=(-(T163*params(4)*exp(y(3)*params(4))));
  g1(20,9)=exp(y(9))-(1-params(7))*exp(y(9));
  g1(21,2)=(-(T197*params(4)*exp(y(2)*params(4))));
  g1(21,8)=exp(y(8))-(1-params(7))*exp(y(8));
  g1(22,5)=exp(y(5));
  g1(22,7)=(-(exp(y(7))*exp(y(11))));
  g1(22,11)=(-(exp(y(7))*exp(y(11))));
  g1(23,4)=exp(y(4));
  g1(23,6)=(-(exp(y(6))*exp((-y(26)))*exp(y(10))));
  g1(23,10)=(-(exp(y(6))*exp((-y(26)))*exp(y(10))));
  g1(23,26)=(-(exp(y(6))*exp(y(10))*(-exp((-y(26))))));
  g1(24,4)=(-exp(y(4)));
  g1(24,5)=(-exp(y(5)));
  g1(24,15)=exp(y(15));
  g1(25,26)=1;
  g1(26,25)=1-(params(15)+params(16));
  g1(27,27)=1;
  g1(28,28)=1;
  g1(29,29)=1;
  g1(30,30)=1;
  g1(31,31)=1;
  g1(32,32)=1;
  g1(33,25)=(-1);
  g1(33,33)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],33,1089);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],33,35937);
end
end
end
end
